* Replication files for
* "Capital Reallocation and the Cyclicality of Aggregate Productivity" by Russ Cooper & Immo Schott
* Prepared: May 2023

* Figure 1
use id year sppe ppent if year >= 1971 using "$datapath/microdata_coopimmo.dta", clear

gen RK_plot = sppe / l.ppent
qui su RK_plot if RK_plot > 0 
gen sd = r(sd)
gen mean = r(mean)
gen RKmax = mean + 2 * sd 
replace RK_plot = RKmax if RK_plot > RKmax & RK_plot < . 
drop mean sd RKmax
gen sample 	= RK_plot > 0 & RK_plot < .

* Save the aggregated data behind histogram
twoway__histogram_gen  RK_plot  if sample == 1, percent bin(10) gen(h x) 

keep h x 
drop if h == . 

save "$mainpath/Figures/Figures_data/Figure1.dta", replace
